/*
 * Decompiled with CFR 0.152.
 */
package top.prefersmin.banitem.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.mojang.text2speech.Narrator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.ServerLifecycleHooks;
import top.prefersmin.banitem.BanItem;

@Mod.EventBusSubscriber(modid="banitem", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BanItemConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec.ConfigValue<List<String>> ITEM_BLACKLIST;
    private static final List<String> ITEM_BLACKLIST_DEFAULT;
    private static final String ITEM_BLACKLIST_NAME = "itemBlacklist";
    private static final String ITEM_BLACKLIST_COMMENT = "\u7269\u54c1\u9ed1\u540d\u5355";
    public static ForgeConfigSpec.ConfigValue<Boolean> ALLOW_OPERATOR_BYPASS;
    private static final Boolean ALLOW_OPERATOR_BYPASS_DEFAULT;
    private static final String ALLOW_OPERATOR_BYPASS_NAME = "allowOperatorBypass";
    private static final String ALLOW_OPERATOR_BYPASS_COMMENT = "\u662f\u5426\u5141\u8bb8OP\u6301\u6709\u9ed1\u540d\u5355\u7269\u54c1";
    public static final ForgeConfigSpec SPEC;
    public static final Path PATH;

    @SubscribeEvent
    public void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            SPEC.setConfig(event.getConfig().getConfigData());
            this.deleteBlacklistItemForWorld();
        }
    }

    public void reloadConfig() {
        CommentedFileConfig commentedFileConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)PATH).sync().autosave().writingMode(WritingMode.REPLACE).build();
        commentedFileConfig.load();
        SPEC.setConfig((CommentedConfig)commentedFileConfig);
        this.deleteBlacklistItemForWorld();
    }

    public void deleteBlacklistItemForWorld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        RegistryAccess.Frozen registryAccess = server.m_206579_();
        Registry dimensionRegistry = registryAccess.m_175515_(Registries.f_256787_);
        dimensionRegistry.forEach(dimensionType -> {
            ServerLevel serverLevel = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionType.f_63837_()));
            if (serverLevel == null) {
                return;
            }
            for (Entity entity : serverLevel.m_8583_()) {
                ItemEntity itemEntity;
                if (!(entity instanceof ItemEntity) || !BanItem.shouldDelete((itemEntity = (ItemEntity)entity).m_32055_())) continue;
                itemEntity.m_142687_(Entity.RemovalReason.KILLED);
                Narrator.LOGGER.info("BanItem\uff1a\u5df2\u5220\u9664\u9ed1\u540d\u5355\u7269\u54c1[{}]", (Object)itemEntity.m_32055_().m_41720_().m_5524_());
            }
        });
    }

    static {
        ITEM_BLACKLIST_DEFAULT = new ArrayList<String>();
        ALLOW_OPERATOR_BYPASS_DEFAULT = true;
        PATH = FMLPaths.CONFIGDIR.get().resolve("banitem-common.toml");
        BUILDER.push("banitem");
        ITEM_BLACKLIST = BUILDER.comment(ITEM_BLACKLIST_COMMENT).define(ITEM_BLACKLIST_NAME, ITEM_BLACKLIST_DEFAULT);
        ALLOW_OPERATOR_BYPASS = BUILDER.comment(ALLOW_OPERATOR_BYPASS_COMMENT).define(ALLOW_OPERATOR_BYPASS_NAME, (Object)ALLOW_OPERATOR_BYPASS_DEFAULT);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

